/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungslaw.world;

import com.yungnickyoung.minecraft.yungslaw.YungsLaw;
import com.yungnickyoung.minecraft.yungslaw.config.Configuration;
import com.yungnickyoung.minecraft.yungslaw.config.io.ConfigLoader;
import com.yungnickyoung.minecraft.yungslaw.config.util.ConfigHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BlockGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int y;
        int z;
        int x;
        if (!(world instanceof WorldServer)) {
            return;
        }
        if (!this.isDimensionWhitelisted(world)) {
            return;
        }
        ConfigHolder config = YungsLaw.configMap.computeIfAbsent(world.field_73011_w.getDimension(), ConfigLoader::loadConfigFromFileForDimension);
        boolean enableOreDeletion = config.enableOreDeletion.get();
        int radius = config.genDistance.get();
        int maxAltitude = config.maxAltitude.get();
        boolean enableLiquidSafety = config.enableLiquidSafety.get();
        IBlockState hardBlock = this.getHardBlockFromString(config.hardBlock.get());
        Set<IBlockState> whitelistedOreBlocks = this.getBlockSetFromNames(config.oreWhitelist.get());
        Set<IBlockState> safeBlocks = this.getBlockSetFromNames(config.safeBlocks.get());
        Set<IBlockState> untouchableBlocks = this.getBlockSetFromNames(config.untouchableBlocks.get());
        int innerXStart = chunkX * 16 + 8;
        int innerZStart = chunkZ * 16 + 8;
        int innerXEnd = innerXStart + 16;
        int innerZEnd = innerZStart + 16;
        int outerXStart = innerXStart - radius;
        int outerZStart = innerZStart - radius;
        int outerXEnd = innerXEnd + radius;
        int outerZEnd = innerZEnd + radius;
        int[][][] values = new int[outerXEnd - outerXStart][maxAltitude + radius][outerZEnd - outerZStart];
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (x = 0; x < outerXEnd - outerXStart; ++x) {
            for (z = 0; z < outerZEnd - outerZStart; ++z) {
                for (y = 0; y < maxAltitude + radius; ++y) {
                    pos.func_181079_c(outerXStart + x, y, outerZStart + z);
                    IBlockState state = world.func_180495_p((BlockPos)pos);
                    values[x][y][z] = safeBlocks.contains(state) || enableLiquidSafety && state.func_185904_a().func_76224_d() ? 0 : (untouchableBlocks.contains(state) ? -1 : (enableOreDeletion && whitelistedOreBlocks.contains(state) ? 3 : 2));
                }
            }
        }
        for (x = outerXStart; x < outerXEnd; ++x) {
            for (z = outerZStart; z < outerZEnd; ++z) {
                for (y = 0; y < maxAltitude + radius; ++y) {
                    if (values[x - outerXStart][y][z - outerZStart] != 0) continue;
                    for (int offsetX = x - outerXStart - radius; offsetX <= x - outerXStart + radius; ++offsetX) {
                        if (offsetX < radius || offsetX > 15 + radius) continue;
                        for (int offsetZ = z - outerZStart - radius; offsetZ <= z - outerZStart + radius; ++offsetZ) {
                            if (offsetZ < radius || offsetZ > 15 + radius) continue;
                            for (int offsetY = y - radius; offsetY <= y + radius; ++offsetY) {
                                if (offsetY < 0 || offsetY > maxAltitude) continue;
                                values[offsetX][offsetY][offsetZ] = Math.min(values[offsetX][offsetY][offsetZ], 1);
                            }
                        }
                    }
                }
            }
        }
        for (x = radius; x < 16 + radius; ++x) {
            for (z = radius; z < 16 + radius; ++z) {
                for (y = 0; y < maxAltitude; ++y) {
                    pos.func_181079_c(x + outerXStart, y, z + outerZStart);
                    if (enableOreDeletion && values[x][y][z] == 3) {
                        world.func_175656_a((BlockPos)pos, world.func_180494_b((BlockPos)pos).field_76753_B);
                        continue;
                    }
                    if (enableOreDeletion || values[x][y][z] != 2) continue;
                    world.func_175656_a((BlockPos)pos, hardBlock);
                }
            }
        }
    }

    private boolean isDimensionWhitelisted(World world) {
        return Configuration.enableGlobalWhitelist || Arrays.stream(Configuration.whitelistedDimensionIDs).anyMatch(id -> id == world.field_73011_w.getDimension());
    }

    private Set<IBlockState> getBlockSetFromNames(String[] blockNames) {
        HashSet<IBlockState> blockStateList = new HashSet<IBlockState>();
        for (String blockName : blockNames) {
            try {
                if (blockName.indexOf(64) > -1) {
                    String[] nameSplit = blockName.split("@", 2);
                    Block block = Block.func_149684_b((String)nameSplit[0]);
                    if (block == null) continue;
                    blockStateList.add(block.func_176203_a(Integer.parseInt(nameSplit[1])));
                    continue;
                }
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) continue;
                blockStateList.add(block.func_176223_P());
            }
            catch (Exception e) {
                YungsLaw.LOGGER.error("ERROR: Unable to find block {}: {}", (Object)blockName, (Object)e);
            }
        }
        return blockStateList;
    }

    private IBlockState getHardBlockFromString(String hardBlockString) {
        IBlockState hardBlock;
        try {
            hardBlock = Block.func_149684_b((String)hardBlockString).func_176223_P();
        }
        catch (Exception e) {
            YungsLaw.LOGGER.error("ERROR: Unable to use block {}: {}", (Object)hardBlockString, (Object)e);
            YungsLaw.LOGGER.error("Using obsidian instead...");
            hardBlock = Blocks.field_150343_Z.func_176223_P();
        }
        if (hardBlock == null) {
            YungsLaw.LOGGER.error("ERROR: Unable to use block {}: null block returned.", (Object)hardBlockString);
            YungsLaw.LOGGER.warn("Using obsidian instead...");
            hardBlock = Blocks.field_150343_Z.func_176223_P();
        }
        return hardBlock;
    }
}

